/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, initialy trivialy, for VGHD by TheEmu.
//

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Modified for EverthangForever so that the selection of which three  functions
// are used can be specified via a uniform parameter in the VGHD scene file.  At
// some point I am very likely to implement a shader of my own based on this one
// but with much more cutomisation possible via the scene file, but all that has
// been done is to use uniforms for function selection and the maximum iteration
// count together with some minor rearrangement of part of the code.  If I do go
// any further with this I will probably make its interface similar to that used
// for my Tunnel A shader and name it accordingly. TheEmu.
//
/////////////////////////////////////////////////////////////////////////////////

// The function "trap" calculates min(max(A,B),C) where A, B and C are  obtained
// by evaluating functions of the current pixel's position.  Which functions are
// specified by the funcA, funcB and funcC uniform parameters. Each of the these
// may be either a function id or a negative function id. Function ids are small
// positive integers and select a function from the following list:- 

   #define func1(p) abs(max(abs(p.z)-0.1,abs(p.x)-0.1))-0.01
   #define func2(p) length(max(abs(p.xy)-0.05,0.0))
   #define func3(p) length(p)-0.5
   #define func4(p) length(max(abs(p)-0.35,0.0))
   #define func5(p) abs(length(p.xz)-0.2)-0.01
   #define func6(p) abs(min(torus(vec3(p.x,mod(p.y,0.4)-0.2,p.z), vec2(0.1,0.05)), max(abs(p.z)-0.05,abs(p.x)-0.05)))-0.005
   #define func7(p) abs(min(torus(p,vec2(0.3,0.05)), max(abs(p.z)-0.05, abs(p.x)-0.05)))-0.005
   #define func8(p) min(length(p.xz), min(length(p.yz), length(p.xy))) - 0.05
 
// If the function id is negated then the value of the function is negated  and  a
// function id of zero always results in 0.0. So, for example, funcSelect = 7,-5,2
// will evaluate min(max(func7,-func5),func2).  Invalid  function  ids are treated
// as if they are 0.

uniform int funcA;
uniform int funcB;
uniform int funcC;

// The maximum iteration count can be set in the scn file. If not specified, or is
// explicitly specified as 0, then a defualt value of 70 is used.

uniform int maxIter;

   int MAX_ITER = (maxIter==0) ? 70 : maxIter;

/////////////////////////////////////////////////////////////////////////////////

// Standard shader inputs

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision highp float;
#endif

vec3 iResolution = vec3(resolution,1.0);

vec2 rotate(in vec2 v, in float a) {
   return vec2(cos(a)*v.x + sin(a)*v.y, -sin(a)*v.x + cos(a)*v.y);
}

float torus(in vec3 p, in vec2 t)
{
   vec2 q = abs(vec2(max(abs(p.x), abs(p.z))-t.x, p.y));
   return max(q.x, q.y)-t.y;
}

float trap(in vec3 p)
{
   float A = 0.0;
   float B = 0.0;
   float C = 0.0;

   int signA = sign(funcA);
   int signB = sign(funcB);
   int signC = sign(funcC);

   switch ( funcA*signA )
    { case 1 : A = func1(p); break;
      case 2 : A = func2(p); break;
      case 3 : A = func3(p); break;
      case 4 : A = func4(p); break;
      case 5 : A = func5(p); break;
      case 6 : A = func6(p); break;
      case 7 : A = func7(p); break;
      case 8 : A = func8(p); break;
    }

   switch ( funcB )
    { case 1 : B = func1(p); break;
      case 2 : B = func2(p); break;
      case 3 : B = func3(p); break;
      case 4 : B = func4(p); break;
      case 5 : B = func5(p); break;
      case 6 : B = func6(p); break;
      case 7 : B = func7(p); break;
      case 8 : B = func8(p); break;
    }

   switch ( funcC*signC )
    { case 1 : C = func1(p); break;
      case 2 : C = func2(p); break;
      case 3 : C = func3(p); break;
      case 4 : C = func4(p); break;
      case 5 : C = func5(p); break;
      case 6 : C = func6(p); break;
      case 7 : C = func7(p); break;
      case 8 : C = func8(p); break;
    }

   A = A * signA;
   B = B * signB;
   C = C * signC;

   return min ( max(A,B), C );

}

float map(in vec3 p)
{
   float cutout = dot(abs(p.yz),vec2(0.5))-0.035;
   float road = max(abs(p.y-0.025), abs(p.z)-0.035);

   vec3 z = abs(1.0-mod(p,2.0));
   z.yz = rotate(z.yz, time*0.05);

   float d = 999.0;
   float s = 1.0;
   for (float i = 0.0; i < 3.0; i++) {
      z.xz = rotate(z.xz, radians(i*10.0+time));
      z.zy = rotate(z.yz, radians((i+1.0)*20.0+time*1.1234));
      z = abs(1.0-mod(z+i/3.0,2.0));

      z = z*2.0 - 0.3;
      s *= 0.5;
      d = min(d, trap(z) * s);
   }
   return min(max(d, -cutout), road);
}

vec3 hsv(in float h, in float s, in float v) {
   return mix(vec3(1.0), clamp((abs(fract(h + vec3(3, 2, 1) / 3.0) * 6.0 - 3.0) - 1.0), 0.0 , 1.0), s) * v;
}

vec3 intersect(in vec3 rayOrigin, in vec3 rayDir)
{
   float total_dist = 0.0;
   vec3 p = rayOrigin;
   float d = 1.0;
   float iter = 0.0;
   float mind = 3.14159+sin(time*0.1)*0.2;

   for (int i = 0; i < MAX_ITER; i++)
   {
      if (d < 0.001) continue;

      d = map(p);
      p += d*vec3(rayDir.x, rotate(rayDir.yz, sin(mind)));
      mind = min(mind, d);
      total_dist += d;
      iter++;
   }

   vec3 color = vec3(0.0);
   if (d < 0.001) {
      float x = (iter/float(MAX_ITER));
      float y = (d-0.01)/0.01/(float(MAX_ITER));
      float z = (0.01-d)/0.01/float(MAX_ITER);
      if (max(abs(p.y-0.025), abs(p.z)-0.035)<0.002) { // Road
         float w = smoothstep(mod(p.x*50.0, 4.0), 2.0, 2.01);
         w -= 1.0-smoothstep(mod(p.x*50.0+2.0, 4.0), 2.0, 1.99);
         w = fract(w+0.0001);
         float a = fract(smoothstep(abs(p.z), 0.0025, 0.0026));
         color = vec3((1.0-x-y*2.)*mix(vec3(0.8, 0.1, 0), vec3(0.1), 1.0-(1.0-w)*(1.0-a)));
      } else {
         float q = 1.0-x-y*2.+z;
         color = hsv(q*0.2+0.85, 1.0-q*0.2, q);
      }
   } else
      color = hsv(d, 1.0, 1.0)*mind*45.0; // Background
   return color;
}

void main()
{
   vec3 upDirection = vec3(0, -1, 0);
   vec3 cameraDir = vec3(1,0,0);
   vec3 cameraOrigin = vec3(time*0.551, 0, 0);

   vec3 u = normalize(cross(upDirection, cameraOrigin));
   vec3 v = normalize(cross(cameraDir, u));
   vec2 screenPos = -1.0 + 2.0 * scaled_gl_FragCoord.xy / iResolution.xy;
   screenPos.x *= iResolution.x / iResolution.y;
   vec3 rayDir = normalize(u * screenPos.x + v * screenPos.y + cameraDir*(1.0-length(screenPos)*0.5));

   gl_FragColor = vec4(intersect(cameraOrigin, rayDir), 1.0);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}